<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Store;


class Stores extends Controller
{
    
    function index()
    {
        $stores = Store::where('channel', 'shopify')
        ->orderBy('store_id', 'DESC')
        ->get();
        return view('store',["data"=>$stores]);
    }
    function get_price($store_id)
    {
       $price_data = Store::where('store_id', $store_id)
    ->select('sms_charge', 'whatsapp_charge', 'whatsapp_charge_category_wise')
    ->first();
       
        if($price_data)
        {
            if(!empty(trim($price_data->whatsapp_charge_category_wise)))
            {
                $price=json_decode($price_data->whatsapp_charge_category_wise,true);
                $utility=$price['utility']??0.00;
                $marketing=$price['marketing']??0.00;
                $authentication=$price['authentication']??0.00;
                $service=$price['service']??0.00;
                $whatsapp_charge_category_wise=json_encode(array("utility"=>$utility,"marketing"=>$marketing,"authentication"=>$authentication,"service"=>$service),JSON_PRESERVE_ZERO_FRACTION);
            }
            else
            {
                $whatsapp_charge_category_wise=json_encode(array("utility"=>0.00,"marketing"=>0.00,"authentication"=>0.00,"service"=>0.00));
            
            }
            $whatsapp_charge_category_wise=json_decode($whatsapp_charge_category_wise,true);
             $category_wise = [
            "utility" => number_format((is_numeric($whatsapp_charge_category_wise['utility']) && $whatsapp_charge_category_wise['utility'] > 0 && !empty(trim($whatsapp_charge_category_wise['utility']))) ? $whatsapp_charge_category_wise['utility'] : 0.0000, 4, '.', ''),
            "marketing" => number_format((is_numeric($whatsapp_charge_category_wise['marketing']) && $whatsapp_charge_category_wise['marketing'] > 0 && !empty(trim($whatsapp_charge_category_wise['marketing']))) ? $whatsapp_charge_category_wise['marketing'] : 0.0000, 4, '.', ''),
            "authentication" => number_format((is_numeric($whatsapp_charge_category_wise['authentication']) && $whatsapp_charge_category_wise['authentication'] > 0 && !empty(trim($whatsapp_charge_category_wise['authentication']))) ? $whatsapp_charge_category_wise['authentication'] : 0.0000, 4, '.', ''),
            "service" => number_format((is_numeric($whatsapp_charge_category_wise['service']) && $whatsapp_charge_category_wise['service'] > 0 && !empty(trim($whatsapp_charge_category_wise['service']))) ? $whatsapp_charge_category_wise['service'] : 0.0000, 4, '.', '')
            ];


            $price_data_sms_charge = $price_data->sms_charge ?? 0.00;
            $price_data_whatsapp_charge = $price_data->whatsapp_charge ?? 0.00;


        }
        else
        {
            
            $category_wise=array("utility"=>0.00,"marketing"=>0.00,"authentication"=>0.00,"service"=>0.00);
            $price=array("sms_charge"=>0.00,"whatsapp_charge"=>0.00,"whatsapp_charge_category_wise"=>$category_wise);
        }
        
        $price_string = '{'
    . '"sms_charge":' . number_format($price_data_sms_charge, 4, '.', '') . ','
    . '"whatsapp_charge":' . number_format($price_data_whatsapp_charge, 4, '.', '') . ','
    . '"whatsapp_charge_category_wise":{'
        . '"utility":' . number_format((is_numeric($category_wise['utility']) && $category_wise['utility'] > 0 && !empty(trim($category_wise['utility'])))?$category_wise['utility']:0.000, 4, '.', '') . ','
        . '"marketing":' . number_format((is_numeric($category_wise['marketing']) && $category_wise['marketing'] > 0 && !empty(trim($category_wise['marketing'])))?$category_wise['marketing']:0.000, 4, '.', '') . ','
        . '"authentication":' . number_format((is_numeric($category_wise['authentication']) && $category_wise['authentication'] > 0 && !empty(trim($category_wise['authentication'])))?$category_wise['authentication']:0.000, 4, '.', '') . ','
        . '"service":' . number_format((is_numeric($category_wise['service']) && $category_wise['service'] > 0 && !empty(trim($category_wise['service'])))?$category_wise['service']:0.000, 4, '.', '')
    . '}'
. '}';
return $price_string;
      
        
    }
    
    public function set_price(Request $request)
    {
        $user = Store::find($request->input('storeId'));
        $updateSuccess =$user->update([
            'sms_charge' => $request->input('smsRate'),
            'whatsapp_charge' => $request->input('whatsappRate'),
            'whatsapp_charge_category_wise' => '{"utility":"' . $request->input('utilityRate') . '", "marketing":"' . $request->input('marketingRate') . '", "authentication":"' . $request->input('authenticationRate') . '", "service":"' . $request->input('serviceRate') . '"}',
        ]);
        if ($updateSuccess) {
    
        return response()->json(['message' => 'Record updated successfully.'],200);
        } else {
        // Failure
        return response()->json(['message' => 'Failed to update the record.'], 400);
        }
    }
    
    
    
}
