<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\WhatsappBusinessModel;
use App\Models\Templates;
use App\Models\TemplatesPending;
use App\Models\TemplatesMarketing;
use App\Models\GlobalModel;

class WhatsappBusiness extends Controller
{
    public function index()
    {
        $details = WhatsappBusinessModel::orderBy('id', 'DESC')->get();
        $k=0;
        foreach($details as $data_details)
        {
            $data = json_decode($data_details->WABA_status, true);
        
            $details[$k]->accountStatus=$data['wabaInfo']['accountStatus']??"";
            $details[$k]->dockerStatus=$data['wabaInfo']['dockerStatus']??"";
            $details[$k]->messagingLimit=$data['wabaInfo']['messagingLimit']??"";
            $details[$k]->phone=$data['wabaInfo']['phone']??"UNKNOWN";//phoneQuality//wabaId//canSendMessage  //additionalInfo//0//1
            $details[$k]->phoneQuality=$data['wabaInfo']['phoneQuality'];
            $details[$k]->wabaId=$data['wabaInfo']['wabaId'];
            $details[$k]->canSendMessage=$data['wabaInfo']['canSendMessage'];
            $details[$k]->additionalInfo=$data['wabaInfo']['additionalInfo']??array();
            $details[$k]->all_info=$data['wabaInfo'];
            $k++;
        }
        

        return view('whatsappbusiness',["data"=>$details]);
    }
    public function get_all_templates($store_id=NULL)
    {
        
        $templates=Templates::where('store_id',$store_id)
                   ->orderBy('id','DESC')
                   ->get()
                   ->toArray();
                   
        $templatesPending=TemplatesPending::where('store_id',$store_id)
                   ->orderBy('id','DESC')
                   ->get()
                   ->toArray();
        $templatesMarketing=TemplatesMarketing::where('store_id',$store_id)
                   ->orderBy('id','DESC')
                   ->get()
                   ->toArray();
                   
        $data=array("templates"=>$templates,"marketingTemplates"=>$templatesMarketing,"templatesPending"=>$templatesPending);
        return json_encode($data);
                   
       
    }
    public function pauseTemplate($elementName,$type,$store_id=NULL)
    {
       $templatesPending = TemplatesPending::where(['store_id' => $store_id, 'elementName' => $elementName])
       ->orderBy('id', 'DESC')
       ->get()
       ->toArray();
        if($templatesPending)
        {
            if($templatesPending[0]['status']==1)
            {
                return response()->json(array("error"=>true,"Msg"=>"Template already submitted to WABA"));
            }
            else if($templatesPending[0]['status']==2)
            {
                return response()->json(array("error"=>true,"Msg"=>"Template already approved"));
            }
            else if($templatesPending[0]['status']==3)
            {
                return response()->json(array("error"=>true,"Msg"=>"Template already Rejected"));
            }
            else if($templatesPending[0]['status']=='0' && $type=='pause')
            {
                $this->update_template_status($templatesPending[0]['id'],4);
                return response()->json(array("error"=>false,"Msg"=>"Template paused sucessfully"));
            }
            else if($templatesPending[0]['status']==4 && $type=='resume')
            {
                $this->update_template_status($templatesPending[0]['id'],0);
                return response()->json(array("error"=>false,"Msg"=>"Template resumed sucessfully"));
            }
            else if($templatesPending[0]['status']==4 && $type=='pause')
            {
                
                return response()->json(array("error"=>false,"Msg"=>"Template paused successfully"));
            }
            else if($templatesPending[0]['status']==0 && $type=='resume')
            {
                
                return response()->json(array("error"=>false,"Msg"=>"Template resumed successfully"));
            }
        }
        else
        {
            return response()->json(array("error"=>true,"Msg"=>"Template Not found ! Please check"));
        }
       
       
    }
    public function update_template_status($id,$status)
    {
        $templates_details=TemplatesPending::find($id);
        $templates_details->status=$status;
        $templates_details->save();
    }
    public function deleteTemplate($elementName,$template_type,$store_id=NULL)
    {
        $globalModel = new GlobalModel();

        // Call the fetch_whatsapp_credentials method
        $credentials = $globalModel->fetch_whatsapp_credentials($store_id);
        
        if(empty($credentials))
        {
            return response()->json(array("error"=>true,"Msg"=>"Issue with credentials ! Please check"));
        }
        else
        {
            
            $credentials=json_encode($credentials);
            $credentials=json_decode($credentials,true);
            $app_id=$credentials[0]['app_id'];
            $app_token=$credentials[0]['app_token'];
            //call gupshup api
            
            $delete_response=$globalModel->delete_gupshup_template($elementName,$app_id,$app_token);
            if($delete_response)
            {
                try {
                    $delete_response=json_decode($delete_response,true);
                    /**  {"status":"success"}  **/
                    if($delete_response['status']=='success')
                    {
                        $globalModel->delete_template_from_db($store_id,$elementName,$template_type);
                        return response()->json(array("error"=>false,"Msg"=>"Template deleted successfully"));
                    }
                    else if($delete_response['message']=='Template Does not exists.')
                    {
                        $globalModel->delete_template_from_db($store_id,$elementName,$template_type);
                        return response()->json(array("error"=>false,"Msg"=>"Template deleted successfully"));
                    }
                    else if($delete_response['status']=='error')
                    {
                        return response()->json(array("error"=>true,"Msg"=>$delete_response['message']));
                    }
                    else
                    {
                        return response()->json(array("error"=>true,"Msg"=>"Unknown Error : Please try again later")); 
                    }
                } catch (Exception $e) {
                    
                    return response()->json(array("error"=>true,"Msg"=>"Unknown Error : Please try again later"));
                }
            }
            else
            {
                //return error unknown
            }
            
        }
        
        
        //make a global modal and declare endpoint values in .env file
        //make the api call to gupshup
        //if its successfull remove template from dataabase
       // return "hello";
    }
    
}
