<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckClientIp
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        $allowedIps = ['192.168.1.1', '111.222.333.444']; 

        $clientIp = $request->header('X-Client-IP'); 

        if (!in_array($clientIp, $allowedIps)) {
            return response()->json(['error' => 'Unauthorized IP'], 403);
        }

        return $next($request);
    }
}
