<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class LoginMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function handle(Request $request, Closure $next): Response
    {
        $userName = session('name');

        if (!$userName) {
            // Redirect to the login page if the user is not logged in
            return redirect('login')->with('error', 'Please log in to access this page.');
        }

        // If the user is logged in, continue with the request
        return $next($request);
    }
}
