<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;


class Wbm extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
         return [
            'inputStoreId'=>'required|exists:spcod_store,store_id',
            'inputAppId'=>'required',
            'inputAppToken'=>'required',
            'inputSecret'=>'required',
            'inputSender'=>'required|numeric',
            'inputAppName'=>'required',
            'inputLanguage'=>'required'
            
        ];
    }
    public function messages(): array
    {
        return [
            'inputStoreId.exists' => 'Store Id is invalid',
            'inputStoreId.required' => 'Please enter store Id',
            'inputAppId.required' => 'Please Enter App Id',
            'inputAppToken.required' => 'Please Enter App Token',
            'inputSecret.required' => 'Please Enter App Secret',
            'inputSender.required' => 'Please Enter Sender Id',
            'inputSender.numeric' => 'Sender Id must be numeric',
            'inputAppName.required' => 'Please enter app name',
            'inputLanguage.required' => 'Please Choose language'
        ];
    }
    
    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(response()->json([
            'success' => false,
            'message' => 'Validation failed.',
            'errors' => $validator->errors(),
        ], 422));
    }
}
