@extends('layouts.master')
@section('title','Welcome')
@php
    $active_menu = ['whatsapp_business'];
@endphp
            @section('content')
            
            <!-- Start::app-content -->
            <div class="main-content app-content">
                <div class="container-fluid">
                <div class="d-md-flex d-block align-items-center justify-content-between my-4 page-header-breadcrumb">
                        <div class="my-auto">
                            <h5 class="page-title fs-21 mb-1">Whatsapp Business</h5>
                            <nav>
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="javascript:void(0);">Whatsapp Business</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">New whatsapp business Manager</li>
                                </ol>
                            </nav>
                        </div>
        
                       <!-- <div class="d-flex my-xl-auto right-content align-items-center">
                            <div class="pe-1 mb-xl-0">
                                <button type="button" class="btn btn-info btn-icon me-2 btn-b"><i class="mdi mdi-filter-variant"></i></button>
                            </div>
                            <div class="pe-1 mb-xl-0">
                                <button type="button" class="btn btn-danger btn-icon me-2"><i class="mdi mdi-star"></i></button>
                            </div>
                            <div class="pe-1 mb-xl-0">
                                <button type="button" class="btn btn-warning  btn-icon me-2"><i class="mdi mdi-refresh"></i></button>
                            </div>
                            <div class="mb-xl-0">
                                <div class="dropdown">
                                    <button class="btn btn-primary" type="button" id="add_new_waba" data-bs-toggle="dropdown" aria-expanded="false">
                                        Add New
                                    </button>
                                    
                                </div>
                            </div>
                        </div>-->
                    </div>
                    	
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                       Add New WBM
                                    </div>
                                </div>
                                <div class="card-body">
                                <form id="wabaForm" method="POST">
                                    <div class="row">
                                    <div class="mb-3 col-xl-4 col-lg-6 col-md-6 col-sm-12">
                                        <label for="inputStoreId" class="form-label">Store Id</label>
                                        <input type="text" maxlength="5" placeholder="Store Id" class="form-control" name="inputStoreId" id="inputStoreId" aria-describedby="storeidHelp">
                                        <small class="text-danger error" id="error_inputStoreId"></small>
                                        <div id="storeidHelp" class="form-text">Please confirm store Id first.</div>
                                    </div>
                                    </div>
                                    <div class="row">
                                    <div class="mb-3 col-xl-4 col-lg-6 col-md-6 col-sm-12">
                                        <label for="inputAppId" class="form-label">App Id</label>
                                        <input type="text" class="form-control" placeholder="App Id" name="inputAppId" id="inputAppId">
                                        <small class="text-danger error" id="error_inputAppId"></small>
                                        
                                    </div>
                                    <div class="mb-3 col-xl-4 col-lg-6 col-md-6 col-sm-12">
                                        <label for="inputAppToken" class="form-label">App Token</label>
                                        <input type="text" class="form-control" placeholder="App Token" name="inputAppToken"  id="inputAppToken">
                                        <small class="text-danger error" id="error_inputAppToken"></small>
                                        
                                    </div>
                                    <div class="mb-3 col-xl-4 col-lg-6 col-md-6 col-sm-12">
                                        <label for="inputSecret" class="form-label">Secret Key</label>
                                        <input type="text" class="form-control" placeholder="Secret Key" name="inputSecret" id="inputSecret">
                                        <small class="text-danger error" id="error_inputSecret"></small>
                                    </div>
                                    <div class="mb-3 col-xl-4 col-lg-6 col-md-6 col-sm-12">
                                        <label for="inputSender" class="form-label">Sender Id</label>
                                        <input type="text" class="form-control" placeholder="Sender Id" name="inputSender" id="inputSender">
                                        <small class="text-danger error" id="error_inputSender"></small>
                                    </div>
                                    <div class="mb-3 col-xl-4 col-lg-6 col-md-6 col-sm-12">
                                        <label for="inputAppName" class="form-label">App Name</label>
                                        <input type="text" class="form-control" placeholder="App Name" name="inputAppName" id="inputAppName">
                                        <small class="text-danger error" id="error_inputAppName"></small>
                                    </div>
                                    <div class="mb-3 col-xl-4 col-lg-6 col-md-6 col-sm-12">
                                        <label for="inputLanguage" class="form-label">Language</label>
                                        <select class="form-select" id="inputLanguage" name="inputLanguage">
                                            <option value="en" selected>English</option>
                                            <option value="fr" >French</option>
                                            <option value="it" >Italian</option>
                                            <option value="ar" >Arabic</option>
                                        </select>
                                        <small class="text-danger error" id="error_inputLanguage"></small>
                                    </div>
                                    
                                    <div class="mb-3 form-check">
                                        <input type="checkbox" class="form-check-input" name="bActive" id="bActive" checked>
                                        <label class="form-check-label" for="bActive">Active</label>
                                        <small class="text-danger error" id="error_bActive"></small>
                                    </div>
                                    <div class="mb-3 form-check">
                                        <input type="checkbox" class="form-check-input" name="inputOverwrite" id="inputOverwrite">
                                        <label class="form-check-label" for="inputOverwrite" >Overwrite if credentials already exists</label>
                                        <small class="text-danger error" id="error_inputOverwrite"></small>
                                    </div>
                                    <div class="mb-3 col-xl-4 col-lg-6 col-md-6 col-sm-12">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                    <button type="submit" class="btn btn-secondary">Cancel</button>
                                    </div>
                                    </div>
                                </form>


                                </div>
                            </div>
                        </div>
                    </div>


                    
                </div>
            </div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
  $('#wabaForm').on('submit', function(e) {
    e.preventDefault(); // prevent actual form submit

var formData = {};
$('#wabaForm').serializeArray().forEach(function(field) {
  formData[field.name] = field.value;
});

    console.log(formData); // for testing, remove in production
    $("small .error").html("");

    // Example AJAX request
    $.ajax({
      url: '{{ env('APP_URL') }}/AddBusiness/add_wbm/', // Change this URL
      method: 'POST',
      data: JSON.stringify(formData),
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
        'Content-Type': 'application/json', 
        'Accept': 'application/json'
    },
      success: function(response) {
         try
         {
            response=JSON.parse(response);
            if(response.success) 
            {
                showCustomAlert({
                title: 'Successsss!',
                message: response.message,
                alertClass: 'alert-success',
                autoClose:2000
            });
            }
            else
            {
                showCustomAlert({
                title: 'Faileddd!',
                message: response.message,
                alertClass: 'alert-danger',
                autoClose:2000
            });
            
            }
         }
         catch(err)
         {
             showCustomAlert({
                title: 'Failed!',
                message: err.message,
                alertClass: 'alert-danger',
                autoClose:2000
            });
         }
        
      },
      error: function(xhr, status, error) {
          
          console.log(xhr.responseJSON.message);
          showCustomAlert({
                            title: 'Failed!',
                            message: xhr.responseJSON.message,
                            alertClass: 'alert-danger',
                            autoClose:2000
                        });
                        
                        for (const key in formData) {
                            if (formData.hasOwnProperty(key)) {
                                if(xhr.responseJSON.errors[key])
                                {
                                    $("#error_"+key).html(xhr.responseJSON.errors[key][0])
                                }
                                else
                                {
                                    $("#error_"+key).html("")
                                }
                                console.log(`Key: ${key}, Value: ${formData[key]}`);
                            }
                        }
        
      }
    });
  
})
})
  </script>