@extends('layouts.master')
@section('title','Welcome')
@php
    $active_menu = ['demo_requests'];
@endphp
            @section('content')
            
            <!-- Start::app-content -->
            <div class="main-content app-content">
                <div class="container-fluid">
                <div class="d-md-flex d-block align-items-center justify-content-between my-4 page-header-breadcrumb">
                        <div class="my-auto">
                            <h5 class="page-title fs-21 mb-1">Demo Requests</h5>
                            <nav>
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="javascript:void(0);">Requests</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Demo</li>
                                </ol>
                            </nav>
                        </div>
        
                        <div class="d-flex my-xl-auto right-content align-items-center">
                            <!--<div class="pe-1 mb-xl-0">
                                <button type="button" class="btn btn-info btn-icon me-2 btn-b"><i class="mdi mdi-filter-variant"></i></button>
                            </div>-->
                            <!--<div class="pe-1 mb-xl-0">
                                <button type="button" class="btn btn-danger btn-icon me-2"><i class="mdi mdi-star"></i></button>
                            </div>-->
                            <div class="pe-1 mb-xl-0">
                                <button type="button" class="btn btn-warning  btn-icon me-2"><i class="mdi mdi-refresh"></i></button>
                            </div>
                            <!--<div class="mb-xl-0">
                                <div class="dropdown">
                                    <button class="btn btn-primary" type="button" id="add_new_waba" data-bs-toggle="dropdown" aria-expanded="false">
                                        Add New
                                    </button>
                                    
                                </div>
                            </div>-->
                        </div>
                    </div>
                    	
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                       Demo Requests Overview
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                    

                                        <table id="responsiveDataTable" class="table table-bordered text-nowrap w-100">
                                            <thead>
                                                <tr>
                                                    <th>S.No. </th>
                                                    
                                                    <th>Name</th>
                                                    <th>Email</th>
                                                    <th>Phone</th>
                                                    <th>Message</th>
                                                    <th>Status</th>
                                                    <th>Action</th>
                                                    <th>Date & Time</th>
                                                    <th>Updated date</th>
                                                    
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php
                                                 $k=1;
                                                
                                                @endphp
                                                @foreach($data as $store_data)
                                                
                                                <tr>
                                                    <td>{{$k}}</td>
                                                    
                                                    <td>{{$store_data['name']}}</td>
                                                    <td>{{$store_data['email']}}</td>
                                                    <td>{{$store_data['contact']}}</td>
                                                    <td> {{$store_data['message']}}</td>
                                                    <td>{{$store_data['bActive']}}</td>
                                                    
                                          <td></td>         
                                                    <td>{{$store_data['date_time']}}</td>
                                                    <td>{{$store_data['updated_time']}}</td>
                                                    <!--<td><button class="btn btn-info-transparent btn-wave waves-effect waves-light btn-sm" data-bs-toggle="modal" data-id="{{$store_data['id']}}" data-bs-target="#templateModal">View Templates<span class="loading"></span></button></td>-->
                                                    
                                                </tr>
                                                @php
                                                 $k++;
                                                @endphp
                                                @endforeach
                                               
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    
                </div>
            </div>
            <!-- Bootstrap 5 Modal -->
<div class="modal fade" id="templateModal" tabindex="-1" aria-labelledby="templateModalLabel"  data-bs-backdrop="static" data-bs-keyboard="false"  aria-labelledby="staticBackdropLabel">
  <div class="modal-dialog modal-fullscreen">
    <div class="modal-content">
      
      <!-- Preloader (Skeleton Loader) -->
      <div class="preloader" id="preloader">
        <h5>Loading...</h5>
        <div class="skeleton my-2" style="width: 80%; height: 30px;"></div>
        <div class="skeleton my-2" style="width: 90%;"></div>
        <div class="skeleton my-2" style="width: 60%;"></div>
        <div class="skeleton my-2" style="width: 75%;"></div>
      </div>

     <div class="modal-header">
        <!--<h5 class="modal-title" id="templateModalLabel">WhatsApp/SMS Rate</h5>-->
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
                            <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                       Approved Templates
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                    

                                        <table id="responsiveDataTable1" class="table table-bordered text-nowrap w-100"></table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                      <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                       Campaign Templates
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                    

                                        <table id="responsiveDataTable2" class="table table-bordered text-nowrap w-100"></table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                      <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                       Pending Or Rejected
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                    

                                        <table id="responsiveDataTable3" class="table table-bordered text-nowrap w-100"></table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
      </div>
    </div>
  </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function deleteTemplate(elementName,template_type)
    {
        var preloader_secondary = document.getElementById("preloader");
        showCustomAlert({
        title: 'Delete Item',
        message: 'Are you sure you want to delete this template?',
        alertClass: 'alert-danger',
        confirmText: 'Yes, Delete',
        cancelText: 'No, Cancel',
        onCancel: function() {
        console.log('User canceled.');
        },
        onConfirm: function() {
        preloader_secondary.classList.remove("hidden");
        $.ajax({
          url:  '{{ env('APP_URL') }}/WhatsappBusiness/deleteTemplate/'+elementName+"/"+template_type+"/"+storeId,
          method: 'GET',
          success: function(response) {
              preloader_secondary.classList.add("hidden");
              try
              {
                  if(response.error)
                  {
                      showCustomAlert({
                            title: 'Error!',
                            message: response.Msg,
                            alertClass: 'alert-danger',
                            autoClose:2000
                        });
                        if(response.Msg=='Template Does not exists.')
                        {
                            loadData(storeId,preloader_secondary);
                        }
                  }
                  else
                  {
                        if ( $.fn.DataTable.isDataTable('#responsiveDataTable1') ) {
                          $('#responsiveDataTable1').DataTable().destroy();
                        }
                        if ( $.fn.DataTable.isDataTable('#responsiveDataTable2') ) {
                          $('#responsiveDataTable2').DataTable().destroy();
                        }
                        if ( $.fn.DataTable.isDataTable('#responsiveDataTable3') ) {
                          $('#responsiveDataTable3').DataTable().destroy();
                        }
                      showCustomAlert({
                            title: 'Success!',
                            message: 'Template deleted successfully !',
                            alertClass: 'alert-success',
                            autoClose:2000
                        });
                        loadData(storeId,preloader_secondary);
                  }
              }
              catch(err)
              {
                  showCustomAlert({
                            title: 'Error!',
                            message: 'Someting went wrong',
                            alertClass: 'alert-danger',
                            autoClose:2000
                        });
              }
              
                     } /** success function ends **/
           
            }) /** ajax request ends **/
            
            },
            });
        
    }
</script>
<script>
    function pauseTemplate(elementName,pause_or_resume)
    {
        var ConfirmMsg="Are you sure you want to pause this template?";
        var MsgClass="alert-danger";
        if(pause_or_resume =='pause')
        {
            ConfirmMsg="Are you sure you want to pause this template?";
            MsgClass="alert-danger";
        }
        if(pause_or_resume =='resume')
        {
            ConfirmMsg="Are you sure you want to resume this template?";
            MsgClass="alert-success";
        }
        var preloader_secondary = document.getElementById("preloader");
        showCustomAlert({
        title: ' ',
        message: ConfirmMsg,
        alertClass: MsgClass,
        confirmText: 'Yes, '+pause_or_resume,
        cancelText: 'No, Cancel',
        onCancel: function() {
        console.log('User canceled.');
        },
        onConfirm: function() {
        preloader_secondary.classList.remove("hidden");
        $.ajax({
          url:  '{{ env('APP_URL') }}/WhatsappBusiness/pauseTemplate/'+elementName+"/"+pause_or_resume+"/"+storeId,
          method: 'GET',
          success: function(response) {
              preloader_secondary.classList.add("hidden");
              try
              {
                  if(response.error)
                  {
                      showCustomAlert({
                            title: 'Error!',
                            message: response.Msg,
                            alertClass: 'alert-danger',
                            autoClose:2000
                        });
                        if(response.Msg=='Template Does not exists.')
                        {
                            loadData(storeId,preloader_secondary);
                        }
                  }
                  else
                  {
                        if ( $.fn.DataTable.isDataTable('#responsiveDataTable1') ) {
                          $('#responsiveDataTable1').DataTable().destroy();
                        }
                        if ( $.fn.DataTable.isDataTable('#responsiveDataTable2') ) {
                          $('#responsiveDataTable2').DataTable().destroy();
                        }
                        if ( $.fn.DataTable.isDataTable('#responsiveDataTable3') ) {
                          $('#responsiveDataTable3').DataTable().destroy();
                        }
                      showCustomAlert({
                            title: 'Success!',
                            message: response.Msg,
                            alertClass: 'alert-success',
                            autoClose:2000
                        });
                        loadData(storeId,preloader_secondary);
                  }
              }
              catch(err)
              {
                  showCustomAlert({
                            title: 'Error!',
                            message: 'Someting went wrong',
                            alertClass: 'alert-danger',
                            autoClose:2000
                        });
              }
              
                     } /** success function ends **/
           
            }) /** ajax request ends **/
            
            },
            });
        
    }
</script>
<script>
     var storeId="";
  document.addEventListener("DOMContentLoaded", function() {
    
   
    
    const preloader = document.getElementById("preloader");

    

    // Show preloader when modal opens
    preloader.classList.remove("hidden"); // Show preloader
    var templateModal = document.getElementById("templateModal");
    templateModal.addEventListener("shown.bs.modal", function() {
    var button = event.relatedTarget;
    if ( $.fn.DataTable.isDataTable('#responsiveDataTable1') ) {
          $('#responsiveDataTable1').DataTable().destroy();
        }
        if ( $.fn.DataTable.isDataTable('#responsiveDataTable2') ) {
          $('#responsiveDataTable2').DataTable().destroy();
        }
        if ( $.fn.DataTable.isDataTable('#responsiveDataTable3') ) {
          $('#responsiveDataTable3').DataTable().destroy();
        }
       
      // Extract info from data-id attribute
      
      storeId = button.getAttribute('data-id');
      loadData(storeId,preloader);
     // console.log(storeId);
      
      
    });
    
  });
  function loadData(storeId,preloader)
  {
      
      $.ajax({
      url:  '{{ env('APP_URL') }}/WhatsappBusiness/get_all_templates/'+storeId,
      method: 'GET',
      success: function(response) {
          preloader.classList.add("hidden");
          try
          {
              data=JSON.parse(response);
              const headings = {
              template: [
                { title: "ID", data: "template_name" },
                { title: "Template Name", data: "mess_type_temp" },
                { title: "Template Type", data: "template_type" },
                { title: "Category", data: "template_category" },
                { title: "Attachments", data: "attachment" },
                { title: "Buttons", data: "buttons" },
                { title: "Actions", data: null, 
                  render: function (data, type, row) {
                    const iconId = data.template_name; 
                    const elementName = data.elementName; 
                    const templateType = "templates"; 
                    return `<i class="fa-solid fa-delete-left"  id="${elementName}" onclick="deleteTemplate(this.id,'template')" style="cursor: pointer;color:red;"></i>`;
                  }
                },
                { title: "Extra String conf", data: "extra_str_conf" },
                { title: "Extra String canc", data: "extra_str_canc" },
                { title: "Template", data: "template",
  render: function (data, type, row) {
    if (typeof data === 'string') {
      return data.replace(/\n/g, '<br>');
    }
    return data;
  } },
              ],
              templatespending: [
                { title: "ID", data: "template_name" },
                { title: "Category", data: "template_category" },
                { title: "Template", data: "template",
                    render: function (data, type, row) {
                    if (typeof data === 'string') {
                      return data.replace(/\n/g, '<br>');
                    }
                    return data;
                    } },
                    { title: "Status", data: null,
                    
                  render: function (data, type, row) {
                    const template_status = data.status; 
                    const elementName_pending = data.elementName; 
                    if(template_status=='0')
                    {
                        return `<span class="text-info">Pending</span> `;
                    }
                    else if(template_status==1)
                    {
                        //submitted cannot pause or delete
                        return `<span class="text-dark" >Submitted</span>`;
                    }
                    else if(template_status==2)
                    {
                        //Approve
                        return `<span class="text-success" >Approved</span>`;
                    }
                    else if(template_status==3)
                    {
                        //Approve
                        return ` <span class="text-danger"  data-bs-toggle="tooltip"   data-bs-placement="top"   title="${data.error_msg}">Rejected</span>`;
                    }
                    else if(template_status==4)
                    {
                        //Approve
                        return `<span class="text-info"  >Paused</span>`;
                    }
                    
                  }
                    },
                    { title: "Action", data: null,
                    
                  render: function (data, type, row) {
                    const template_status = data.status; 
                    const elementName_pending = data.elementName; 
                    if(template_status=='0')
                    {
                        return `<button class="btn btn-info btn-sm"  id="${elementName_pending}" onclick="pauseTemplate(this.id,'pause')" style="cursor: pointer;">Pause</button> <button class="btn btn-danger btn-sm"  id="${elementName_pending}" onclick="deleteTemplate(this.id,'pending')" style="cursor: pointer;color:red;">Delete</button>`;
                    }
                    else if(template_status==1)
                    {
                        //submitted cannot pause or delete
                        return `<button class="btn btn-secondary btn-sm" >Submitted</button>`;
                    }
                    else if(template_status==2)
                    {
                        //Approve
                        return `<button  class="btn btn-success btn-sm" >Approved</button>`;
                    }
                    else if(template_status==3)
                    {
                        //Approve
                        return `<button class="btn btn-danger btn-sm"  id="${elementName_pending}" onclick="deleteTemplate(this.id,'resume')" style="cursor: pointer;color:red;">Delete</button> <button class="btn btn-dark btn-sm"  data-bs-toggle="tooltip"   data-bs-placement="top"   title="${data.error_msg}">Reason ?</button>`;
                    }
                    else if(template_status==4)
                    {
                        //Approve
                        return `<button class="btn btn-warning btn-sm"  id="${elementName_pending}" onclick="pauseTemplate(this.id,'resume')" style="cursor: pointer;">Resume</button> <button class="btn btn-danger btn-sm"  id="${elementName_pending}" onclick="deleteTemplate(this.id,'pending')" style="cursor: pointer;color:red;">Delete</button>`;
                    }
                    
                  }
                    },
                    { title: "Template Type", data: "template_type" },
              ],
              templatesmarketing: [
                { title: "ID", data: "template_name" },
                { title: "Template Name", data: "name" },
                { title: "Template", data: "text",
                    render: function (data, type, row) {
                    if (typeof data === 'string') {
                      return data.replace(/\n/g, '<br>');
                    }
                    return data;
                    } },
                { title: "Actions", data: null, 
                  render: function (data, type, row) {
                    const iconId = data.template_name; 
                    const elementName = data.elementName; 
                    const templateType = "templates"; 
                    return `<i class="fa-solid fa-delete-left"  id="${elementName}" onclick="deleteTemplate(this.id,'marketing')" style="cursor: pointer;color:red;"></i>`;
                  }
                },
                { title: "Button Text", data: "button_text" },
                { title: "Button URL", data: "button_url" }
              ]
            };
            
            createDataTable('responsiveDataTable1', data.templates, headings.template);
            createDataTable('responsiveDataTable2', data.marketingTemplates, headings.templatesmarketing);
            createDataTable('responsiveDataTable3', data.templatesPending, headings.templatespending);
              
          }
          catch(err)
          {
              toastr["error"](err.message);
          }
         
        console.log(response);
        // var data = JSON.parse(response);
      },
      error: function(xhr) {
        toastr["error"]("Oops", "Something went wrong");
       // console.error('Request failed', xhr);
      }
    });
  }
  function createDataTable(tableId, tableData, columns) {
  $(`#${tableId}`).DataTable({
    data: tableData,
    columns: columns,
     responsive: true
  });
}
</script>
<script>
    $(document).ready(function() {
    $('#responsiveModal1').on('shown.bs.modal', function () {
        if (!$.fn.DataTable.isDataTable('#responsiveDataTable1')) {
            $('#responsiveDataTable1').DataTable({
                responsive: true,
                paging: true,
                searching: true
            });
        }
    });

    $('#responsiveModal2').on('shown.bs.modal', function () {
        if (!$.fn.DataTable.isDataTable('#responsiveDataTable2')) {
            $('#responsiveDataTable2').DataTable({
                responsive: true,
                paging: true,
                searching: true
            });
        }
    });

    $('#responsiveModal3').on('shown.bs.modal', function () {
        if (!$.fn.DataTable.isDataTable('#responsiveDataTable3')) {
            $('#responsiveDataTable3').DataTable({
                responsive: true,
                paging: true,
                searching: true
            });
        }
    });
});

</script>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    tooltipTriggerList.forEach(function (tooltipTriggerEl) {
      new bootstrap.Tooltip(tooltipTriggerEl)
    })
  });
</script>
<script>
    $("#add_new_waba").click(function(){
        window.location.href="AddBusiness";
    })
</script>
 @endsection
