@extends('layouts.master')
@section('title','Welcome')
@php
    $active_menu = ['stores'];
@endphp
            @section('content')
           
            <!-- Start::app-content -->
            <div class="main-content app-content">
                <div class="container-fluid">
                <div class="d-md-flex d-block align-items-center justify-content-between my-4 page-header-breadcrumb">
                        <div class="my-auto">
                            <h5 class="page-title fs-21 mb-1">Stores</h5>
                            <nav>
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="javascript:void(0);">Stores</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Store List</li>
                                </ol>
                            </nav>
                        </div>
        
                        <div class="d-flex my-xl-auto right-content align-items-center">
                            <div class="pe-1 mb-xl-0">
                                <button type="button" class="btn btn-info btn-icon me-2 btn-b"><i class="mdi mdi-filter-variant"></i></button>
                            </div>
                            <div class="pe-1 mb-xl-0">
                                <button type="button" class="btn btn-danger btn-icon me-2"><i class="mdi mdi-star"></i></button>
                            </div>
                            <div class="pe-1 mb-xl-0">
                                <button type="button" class="btn btn-warning  btn-icon me-2"><i class="mdi mdi-refresh"></i></button>
                            </div>
                            <div class="mb-xl-0">
                                <div class="dropdown">
                                    <button class="btn btn-primary" type="button" id="dropdownMenuDate" data-bs-toggle="dropdown" aria-expanded="false">
                                        14 Aug 2019
                                    </button>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                    	
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                       Stores Overview
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                    

                                        <table id="responsiveDataTable" class="table table-bordered text-nowrap w-100">
                                            <thead>
                                                <tr>
                                                    <th>Store Id </th>
                                                    <th>Store Name</th>
                                                    <th>Store URL</th>
                                                    <th>Credit Left</th>
                                                    <th>Email</th>
                                                    <th>Country</th>
                                                    <th>Msg Rates</th>
                                                    <th>App Login</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($data as $store_data)
                                                
                                                <tr>
                                                    <td>{{$store_data->store_id}}</td>
                                                    <td>{{$store_data->store_name}}</td>
                                                    <td>{{$store_data->store_url}}</td>
                                                    <td> $ {{$store_data->call_credit_left}}</td>
                                                    <td>{{$store_data->email}}</td>
                                                    <td>{{$store_data->country}}</td>
                                                    <td><button class="btn btn-info-transparent btn-wave waves-effect waves-light btn-sm" data-bs-toggle="modal" data-id="{{$store_data->store_id}}" data-bs-target="#rateModal">Set Rates <span class="loading"></span></button></td>
                                                    
                                                    <td>
                                                    @if($store_data->status=='1')    
                                                    <a href="https://glideteck.in/verification-app/login?shop={{$store_data->store_url}}" target="_blank"><button class="btn btn-primary btn-sm btn-wave" >Login App</button></a>
                                                    @else 
                                                    <button class="btn btn-danger btn-sm btn-wave" >App Uninstalled</button>
                                                    @endif
                                                    </td>
                                                </tr>
                                                @endforeach
                                               
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    
                </div>
            </div>
            
            
 <!-- Bootstrap 5 Modal -->
<div class="modal fade" id="rateModal" tabindex="-1" aria-labelledby="rateModalLabel"  data-bs-backdrop="static" data-bs-keyboard="false"  aria-labelledby="staticBackdropLabel">
  <div class="modal-dialog">
    <div class="modal-content">
      
      <!-- Preloader (Skeleton Loader) -->
      <div class="preloader" id="preloader">
        <h5>Loading...</h5>
        <div class="skeleton my-2" style="width: 80%; height: 30px;"></div>
        <div class="skeleton my-2" style="width: 90%;"></div>
        <div class="skeleton my-2" style="width: 60%;"></div>
        <div class="skeleton my-2" style="width: 75%;"></div>
      </div>

      <div class="modal-header">
        <h5 class="modal-title" id="rateModalLabel">WhatsApp/SMS Rate</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="rateForm" method="POST">
          <!-- SMS Rate -->
          <div class="mb-3">
            <label for="smsRate" class="form-label">SMS Rate</label>
            <input type="number" class="form-control" step="any" id="smsRate" name="smsRate" placeholder="Enter SMS rate">
          </div>

          <!-- WhatsApp Rate -->
          <div class="mb-3">
            <label for="whatsappRate" class="form-label">WhatsApp Rate</label>
            <input type="number" class="form-control" step="any" id="whatsappRate" name="whatsappRate" placeholder="Enter WhatsApp rate">
          </div>

          <!-- WhatsApp Rate Category-wise -->
          <label class="form-label">WhatsApp Rate Category-wise</label>
          <div class="mb-3">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="marketingCheckbox">
              <label class="form-check-label" for="marketingCheckbox">Marketing</label>
              <input type="number" step="any" class="form-control mt-1" id="marketingRate" name="marketingRate" placeholder="Enter rate" disabled>
            </div>

            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="utilityCheckbox">
              <label class="form-check-label" for="utilityCheckbox">Utility</label>
              <input type="number" step="any" class="form-control mt-1" id="utilityRate" name="utilityRate" placeholder="Enter rate" disabled>
            </div>

            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="authenticationCheckbox">
              <label class="form-check-label" for="authenticationCheckbox">Authentication</label>
              <input type="number" step="any" class="form-control mt-1" id="authenticationRate" name="authenticationRate" placeholder="Enter rate" disabled>
            </div>

            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="serviceCheckbox">
              <label class="form-check-label" for="serviceCheckbox">Service</label>
              <input type="number" step="any" class="form-control mt-1" id="serviceRate" name="serviceRate" placeholder="Enter rate" disabled>
            </div>
          </div>

          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Save Rates</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>

  var storeId="";
  document.addEventListener("DOMContentLoaded", function() {
    const checkboxes = document.querySelectorAll(".form-check-input");
    const preloader = document.getElementById("preloader");

    // Enable/disable input fields based on checkboxes
    checkboxes.forEach(checkbox => {
      checkbox.addEventListener("change", function() {
        const inputField = this.nextElementSibling.nextElementSibling;
        inputField.disabled = !this.checked;
      });
    });

    // Show preloader when modal opens
    preloader.classList.remove("hidden"); // Show preloader
    var rateModal = document.getElementById("rateModal");
    rateModal.addEventListener("shown.bs.modal", function() {
    var button = event.relatedTarget;
  
      // Extract info from data-id attribute
      
      storeId = button.getAttribute('data-id');
      //console.log(dataId);
      
      $.ajax({
      url:  '{{ env('APP_URL') }}/stores/get_price/'+storeId,
      method: 'GET',
      success: function(response) {
          preloader.classList.add("hidden");
          try
          {
              response=JSON.parse(response);
              document.getElementById("smsRate").value=response.sms_charge;
              document.getElementById("whatsappRate").value=response.whatsapp_charge;
              document.getElementById("marketingRate").value=response.whatsapp_charge_category_wise.marketing;
              document.getElementById("utilityRate").value=response.whatsapp_charge_category_wise.utility;
              document.getElementById("authenticationRate").value=response.whatsapp_charge_category_wise.authentication;
              document.getElementById("serviceRate").value=response.whatsapp_charge_category_wise.service;
              
          }
          catch(err)
          {
              toastr["error"](err.message);
          }
         
        console.log(response);
        // var data = JSON.parse(response);
      },
      error: function(xhr) {
        toastr["error"]("Oops", "Something went wrong");
       // console.error('Request failed', xhr);
      }
    });

      
      
      
      
    });
    
  });

$(document).ready(function() {
  $('#rateForm').on('submit', function(e) {
    e.preventDefault(); // prevent actual form submit

    // Get the basic rates
    var smsRate = parseFloat($('#smsRate').val()) || 0;
    var whatsappRate = parseFloat($('#whatsappRate').val()) || 0;

    // Basic validation for SMS and WhatsApp rates
    if (smsRate < 0) {
      alert('SMS Rate must be 0 or greater.');
      return;
    }
    if (whatsappRate < 0) {
      alert('WhatsApp Rate must be 0 or greater.');
      return;
    }

    // Prepare WhatsApp category-wise rates
    var marketingRate = handleCategory('marketingCheckbox', 'marketingRate');
    var utilityRate = handleCategory('utilityCheckbox', 'utilityRate');
    var authenticationRate = handleCategory('authenticationCheckbox', 'authenticationRate');
    var serviceRate = handleCategory('serviceCheckbox', 'serviceRate');

    if (marketingRate === false || utilityRate === false || authenticationRate === false || serviceRate === false) {
      // If any invalid rate, exit
      return;
    }

    // Now prepare data to send via AJAX
    var formData = {
      smsRate: smsRate,
      whatsappRate: whatsappRate,
      marketingRate: marketingRate,
      utilityRate: utilityRate,
      authenticationRate: authenticationRate,
      serviceRate: serviceRate,
      storeId:storeId
    };

    console.log(formData); // for testing, remove in production

    // Example AJAX request
    $.ajax({
      url: '{{ env('APP_URL') }}/stores/set_price/', // Change this URL
      method: 'POST',
      data: formData,
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
      success: function(response) {
        toastr["success"]("Saved", "Rates saved successfully");
        // Optionally do something with the response
      },
      error: function(xhr, status, error) {
          toastr["error"]("An error occurred while saving rates", "Please try again later");
        alert('An error occurred while saving rates.');
      }
    });
  });

  function handleCategory(checkboxId, rateInputId) {
    if ($('#' + checkboxId).is(':checked')) {
      var rate = parseFloat($('#' + rateInputId).val());
      if (isNaN(rate) || rate < 0) {
        alert('Rate for ' + checkboxId.replace('Checkbox', '') + ' must be 0 or greater.');
        return false;
      }
      return rate;
    } else {
      return 0; // default 0 if checkbox not checked
    }
  }

  // Enable/disable input fields based on checkbox
  $('.form-check-input').on('change', function() {
    var relatedInput = $(this).closest('.form-check').find('input[type="number"]');
    if ($(this).is(':checked')) {
      relatedInput.prop('disabled', false);
    } else {
      relatedInput.prop('disabled', true).val('');
    }
  });
});
</script>

 @endsection
