<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Stores;
use App\Http\Controllers\WhatsappBusiness;
use App\Http\Controllers\Login;
use App\Http\Controllers\AddBusiness;
use App\Http\Controllers\DemoRequests;
use App\Http\Controllers\WabaRequests;
use App\Http\Middleware\LoginMiddleware;


Route::post('/login',[Login::class,'login']);




Route::group(['middleware' => LoginMiddleware::class], function () {    
    Route::get('overview', [DashboardController::class, 'index']); 
    Route::get('stores', [Stores::class, 'index']);
    Route::get('WhatsappBusiness', [WhatsappBusiness::class, 'index']);
    Route::get('AddBusiness', [AddBusiness::class, 'index']);
    Route::post('AddBusiness/add_wbm/', [AddBusiness::class, 'add_wbm']);
    
    Route::get('DemoRequests/', [DemoRequests::class, 'index']);
    Route::get('WabaRequests/', [WabaRequests::class, 'index']);
    
    
    //WabaRequests
    
});

Route::get('stores/get_price/{id}', [Stores::class, 'get_price']);

Route::post('stores/set_price/', [Stores::class, 'set_price']);

Route::get('WhatsappBusiness/get_all_templates/{id?}', [WhatsappBusiness::class, 'get_all_templates']);

Route::get('WhatsappBusiness/deleteTemplate/{elementName}/{type}/{store_id?}', [WhatsappBusiness::class, 'deleteTemplate']);

Route::get('WhatsappBusiness/pauseTemplate/{elementName}/{type}/{store_id?}', [WhatsappBusiness::class, 'pauseTemplate']);
/**  pauseTemplate($elementName,$type,$store_id=NULL) **/

//Route::get('user',[UserController::class,'getUser']);

//Route::get('userDynamic/{name}',[UserController::class,'getUserDynamic']);

//Route::get('login',[UserController::class,'login']);
//Route::get('/home',[UserController::class,'index']);
//Route::view('/','home');
Route::view('/login','login');
