<?php $__env->startSection('title','Welcome'); ?>

            <?php $__env->startSection('content'); ?>
            <style>
        /* Skeleton Loader Effect */
        .skeleton {
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: shimmer 1.5s infinite linear;
            height: 20px;
            border-radius: 5px;
        }

        @keyframes shimmer {
            0% { background-position: -200% 0; }
            100% { background-position: 200% 0; }
        }

        /* Preloader Style */
        .preloader {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: #fff;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: column;
            z-index: 1050; /* Above modal */
        }

        .hidden {
            display: none !important;
        }
    </style>
            <!-- Start::app-content -->
            <div class="main-content app-content">
                <div class="container-fluid">
                <div class="d-md-flex d-block align-items-center justify-content-between my-4 page-header-breadcrumb">
                        <div class="my-auto">
                            <h5 class="page-title fs-21 mb-1">Stores</h5>
                            <nav>
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="javascript:void(0);">Stores</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Store List</li>
                                </ol>
                            </nav>
                        </div>
        
                        <div class="d-flex my-xl-auto right-content align-items-center">
                            <div class="pe-1 mb-xl-0">
                                <button type="button" class="btn btn-info btn-icon me-2 btn-b"><i class="mdi mdi-filter-variant"></i></button>
                            </div>
                            <div class="pe-1 mb-xl-0">
                                <button type="button" class="btn btn-danger btn-icon me-2"><i class="mdi mdi-star"></i></button>
                            </div>
                            <div class="pe-1 mb-xl-0">
                                <button type="button" class="btn btn-warning  btn-icon me-2"><i class="mdi mdi-refresh"></i></button>
                            </div>
                            <div class="mb-xl-0">
                                <div class="dropdown">
                                    <button class="btn btn-primary" type="button" id="dropdownMenuDate" data-bs-toggle="dropdown" aria-expanded="false">
                                        14 Aug 2019
                                    </button>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                    	
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                       Stores Overview
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                    

                                        <table id="responsiveDataTable" class="table table-bordered text-nowrap w-100">
                                            <thead>
                                                <tr>
                                                    <th>Store Id </th>
                                                    <th>Store Name</th>
                                                    <th>Store URL</th>
                                                    <th>Credit Left</th>
                                                    <th>Email</th>
                                                    <th>Country</th>
                                                    <th>Msg Rates</th>
                                                    <th>App Login</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                
                                                <tr>
                                                    <td><?php echo e($store_data->store_id); ?></td>
                                                    <td><?php echo e($store_data->store_name); ?></td>
                                                    <td><?php echo e($store_data->store_url); ?></td>
                                                    <td> $ <?php echo e($store_data->call_credit_left); ?></td>
                                                    <td><?php echo e($store_data->email); ?></td>
                                                    <td><?php echo e($store_data->country); ?></td>
                                                    <td><button class="btn btn-info-transparent btn-wave waves-effect waves-light btn-sm" data-bs-toggle="modal" data-bs-target="#rateModal">Set Rates <span class="loading"></span></button></td>
                                                    
                                                    <td>
                                                    <?php if($store_data->status=='1'): ?>    
                                                    <a href="https://simplifycommerce.online/verification-app/login?shop=<?php echo e($store_data->store_url); ?>" target="_blank"><button class="btn btn-primary btn-sm btn-wave" >Login App</button></a>
                                                    <?php else: ?> 
                                                    <button class="btn btn-danger btn-sm btn-wave" >App Uninstalled</button>
                                                    <?php endif; ?>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                               
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    
                </div>
            </div>
            
            
 <!-- Bootstrap 5 Modal -->
<div class="modal fade" id="rateModal" tabindex="-1" aria-labelledby="rateModalLabel"  data-bs-backdrop="static" data-bs-keyboard="false"  aria-labelledby="staticBackdropLabel">
  <div class="modal-dialog">
    <div class="modal-content">
      
      <!-- Preloader (Skeleton Loader) -->
      <div class="preloader" id="preloader">
        <h5>Loading...</h5>
        <div class="skeleton my-2" style="width: 80%; height: 30px;"></div>
        <div class="skeleton my-2" style="width: 90%;"></div>
        <div class="skeleton my-2" style="width: 60%;"></div>
        <div class="skeleton my-2" style="width: 75%;"></div>
      </div>

      <div class="modal-header">
        <h5 class="modal-title" id="rateModalLabel">WhatsApp/SMS Rate</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="rateForm">
          <!-- SMS Rate -->
          <div class="mb-3">
            <label for="smsRate" class="form-label">SMS Rate</label>
            <input type="number" class="form-control" id="smsRate" name="smsRate" placeholder="Enter SMS rate">
          </div>

          <!-- WhatsApp Rate -->
          <div class="mb-3">
            <label for="whatsappRate" class="form-label">WhatsApp Rate</label>
            <input type="number" class="form-control" id="whatsappRate" name="whatsappRate" placeholder="Enter WhatsApp rate">
          </div>

          <!-- WhatsApp Rate Category-wise -->
          <label class="form-label">WhatsApp Rate Category-wise</label>
          <div class="mb-3">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="marketingCheckbox">
              <label class="form-check-label" for="marketingCheckbox">Marketing</label>
              <input type="number" class="form-control mt-1" id="marketingRate" name="marketingRate" placeholder="Enter rate" disabled>
            </div>

            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="utilityCheckbox">
              <label class="form-check-label" for="utilityCheckbox">Utility</label>
              <input type="number" class="form-control mt-1" id="utilityRate" name="utilityRate" placeholder="Enter rate" disabled>
            </div>

            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="authenticationCheckbox">
              <label class="form-check-label" for="authenticationCheckbox">Authentication</label>
              <input type="number" class="form-control mt-1" id="authenticationRate" name="authenticationRate" placeholder="Enter rate" disabled>
            </div>

            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="serviceCheckbox">
              <label class="form-check-label" for="serviceCheckbox">Service</label>
              <input type="number" class="form-control mt-1" id="serviceRate" name="serviceRate" placeholder="Enter rate" disabled>
            </div>
          </div>

          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Save Rates</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<script>
  document.addEventListener("DOMContentLoaded", function() {
    const checkboxes = document.querySelectorAll(".form-check-input");
    const preloader = document.getElementById("preloader");

    // Enable/disable input fields based on checkboxes
    checkboxes.forEach(checkbox => {
      checkbox.addEventListener("change", function() {
        const inputField = this.nextElementSibling.nextElementSibling;
        inputField.disabled = !this.checked;
      });
    });

    // Show preloader when modal opens
    var rateModal = document.getElementById("rateModal");
    rateModal.addEventListener("shown.bs.modal", function() {
      preloader.classList.remove("hidden"); // Show preloader
      setTimeout(() => {
        preloader.classList.add("hidden"); // Hide preloader after 2 seconds
      }, 2000);
    });
  });
</script>           

 <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/eenginei/public_html/glideteck/dashboard/resources/views/store.blade.php ENDPATH**/ ?>